/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWMapNode;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWStepAttribute;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.table.VWFieldDataForTable;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.awt.ComponentOrientation;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;

public final class VWAttributesTableModel
extends AbstractTableModel
implements IVWPropertyChangeSource {
    private static final int NUM_COLUMNS = 3;
    public static final int COL_NAME = 0;
    public static final int COL_TYPE = 1;
    public static final int COL_VALUE = 2;
    protected static final String ARRAY = "[ ]";
    private JComboBox m_fieldTypeComboBox = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWMapNode m_mapNode = null;
    private Vector m_rowData = null;
    private Vector m_changedItems = null;
    private VWStepAttribute m_tempStepAttribute = null;

    public VWAttributesTableModel(VWAuthPropertyData authPropertyData, VWMapNode mapNode) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.m_mapNode = mapNode;
            this.m_rowData = new Vector();
            this.m_tempStepAttribute = new VWStepAttribute();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public JComboBox getFieldTypeComboBox() {
        try {
            if (this.m_fieldTypeComboBox == null) {
                this.m_fieldTypeComboBox = new JComboBox();
                this.m_fieldTypeComboBox.setRenderer(new VWLabelListCellRenderer());
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(4));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(4) + ARRAY);
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(8));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(8) + ARRAY);
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(1));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(1) + ARRAY);
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(2));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(2) + ARRAY);
                ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
                this.m_fieldTypeComboBox.applyComponentOrientation(compOrientation);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_fieldTypeComboBox;
    }

    public void setSelectedStep(VWMapNode mapNode) {
        if (this.m_mapNode != mapNode) {
            this.m_mapNode = mapNode;
            this.reinitialize();
        }
    }

    public void releaseReferences() {
        if (this.m_fieldTypeComboBox != null) {
            this.m_fieldTypeComboBox.removeAll();
            this.m_fieldTypeComboBox = null;
        }
        if (this.m_rowData != null) {
            this.m_rowData.removeAllElements();
            this.m_rowData = null;
        }
        if (this.m_changedItems != null) {
            this.m_changedItems.removeAllElements();
            this.m_changedItems = null;
        }
        this.m_tempStepAttribute = null;
        this.m_authPropertyData = null;
        this.m_mapNode = null;
    }

    public void deleteItem(int nRowIndex) {
        block3: {
            try {
                VWStepAttribute attribute = this.getItemAt(nRowIndex);
                if (attribute != null) {
                    this.m_rowData.removeElementAt(nRowIndex);
                }
                this.fireTableRowsDeleted(nRowIndex, nRowIndex);
                this.m_authPropertyData.setDirty();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block3;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    public void reinitialize() {
        try {
            this.m_rowData.removeAllElements();
            if (this.m_mapNode != null) {
                Object[] attributeNames;
                VWAttributeInfo attributeInfo = this.m_mapNode.getAttributeInfo();
                if (attributeInfo != null && (attributeNames = attributeInfo.getAttributeNames()) != null && attributeNames.length > 0) {
                    VWQubbleSort.sort(attributeNames);
                    for (int i = 0; i < attributeNames.length; ++i) {
                        Object name = attributeNames[i];
                        if (((String)name).length() > 2 && ((String)name).substring(1, 2).compareTo("F_") == 0 || ((String)name).compareTo("UI_StepType") == 0) continue;
                        int nType = attributeInfo.getFieldType((String)name);
                        boolean bIsArray = attributeInfo.isFieldArray((String)name);
                        Object value = attributeInfo.getFieldValue((String)name);
                        this.m_rowData.addElement(new VWStepAttribute((String)name, nType, bIsArray, value));
                    }
                }
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int findIndex(String attributeName) {
        if (attributeName != null && attributeName.length() > 0) {
            for (int i = 0; i < this.m_rowData.size(); ++i) {
                VWStepAttribute stepAttr = this.getItemAt(i);
                if (stepAttr == null || VWStringUtils.compare(stepAttr.getName(), attributeName) != 0) continue;
                return i;
            }
        }
        return -1;
    }

    public void notifyPropertyChange() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 503);
    }

    public Vector getItemsChanged() {
        return this.m_changedItems;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Object.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.s_nameStr;
            }
            case 1: {
                return VWResource.s_typeStr;
            }
            case 2: {
                return VWResource.s_value;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWStepAttribute stepAttribute = this.getItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (stepAttribute == null) break;
                    return stepAttribute.getName();
                }
                case 1: {
                    if (stepAttribute != null) {
                        return stepAttribute.getTypeString();
                    }
                    return this.m_tempStepAttribute.getTypeString();
                }
                case 2: {
                    if (stepAttribute != null) {
                        return new VWFieldDataForTable(stepAttribute.getType(), stepAttribute.isArray(), stepAttribute.getValue(), stepAttribute.getName());
                    }
                    return new VWFieldDataForTable(this.m_tempStepAttribute.getType(), this.m_tempStepAttribute.isArray(), this.m_tempStepAttribute.getValue(), this.m_tempStepAttribute.getName());
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return true;
    }

    public void setValueAt(Object value, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                this.onUpdateName(value, nRowIndex);
                break;
            }
            case 2: {
                this.onUpdateValue(value, nRowIndex);
                break;
            }
            case 1: {
                this.onUpdateType(value, nRowIndex);
            }
        }
    }

    private VWStepAttribute getItemAt(int nRowIndex) {
        try {
            Object obj;
            if (this.m_rowData != null && nRowIndex < this.m_rowData.size() && (obj = this.m_rowData.get(nRowIndex)) != null && obj instanceof VWStepAttribute) {
                return (VWStepAttribute)obj;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private void onUpdateName(Object value, int nRowIndex) {
        block10: {
            try {
                String newName;
                if (value != null && (newName = (String)value).length() > 0) {
                    VWStepAttribute stepAttribute = this.getItemAt(nRowIndex);
                    if (stepAttribute != null) {
                        String oldName = stepAttribute.getName();
                        if (VWStringUtils.compare(newName, oldName) == 0) {
                            return;
                        }
                        if (this.isExistingName(newName)) {
                            throw new VWException("vw.toolkit.design.property.tables.AttributeNameInUse", "The attribute name is already in use.");
                        }
                        stepAttribute.setName(newName, this.m_mapNode);
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                        if (VWStringUtils.compare(oldName, "UI_IconName") == 0 || VWStringUtils.compare(newName, "UI_IconName") == 0) {
                            this.m_changedItems = new Vector();
                            this.m_changedItems.addElement(this.m_mapNode);
                            this.notifyPropertyChange();
                        }
                    } else {
                        if (this.isExistingName(newName)) {
                            throw new VWException("vw.toolkit.design.property.tables.AttributeNameInUse", "The attribute name is already in use.");
                        }
                        this.m_tempStepAttribute.setName(newName, this.m_mapNode);
                        if (VWStringUtils.compare(newName, "UI_IconName") == 0 || VWStringUtils.compare(newName, "UI_StepPropertiesPanelClass") == 0) {
                            this.m_tempStepAttribute.setType(2, false, null);
                        }
                        this.m_rowData.addElement(this.m_tempStepAttribute);
                        this.m_tempStepAttribute = new VWStepAttribute();
                        this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                    }
                    this.m_authPropertyData.setDirty();
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block10;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    private boolean isExistingName(String name) {
        try {
            if (this.m_rowData != null) {
                for (int i = 0; i < this.m_rowData.size(); ++i) {
                    Object obj = this.m_rowData.get(i);
                    if (obj == null || !(obj instanceof VWStepAttribute) || VWStringUtils.compare(name, ((VWStepAttribute)obj).getName()) != 0) continue;
                    return true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    private void onUpdateType(Object value, int nRowIndex) {
        block7: {
            try {
                if (value != null) {
                    String newType = (String)value;
                    VWStepAttribute attribute = this.getItemAt(nRowIndex);
                    if (attribute != null) {
                        String oldType = attribute.getTypeString();
                        if (VWStringUtils.compare(oldType, newType) != 0) {
                            this.updateAttributeValue(attribute, newType, this.m_mapNode);
                            this.m_authPropertyData.setDirty();
                        }
                    } else {
                        String oldType = this.m_tempStepAttribute.getTypeString();
                        if (VWStringUtils.compare(oldType, newType) != 0) {
                            this.updateAttributeValue(this.m_tempStepAttribute, newType, null);
                        }
                    }
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block7;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    private void updateAttributeValue(VWStepAttribute attribute, String newType, VWMapNode vwMapNode) throws Exception {
        if (newType.compareTo(VWFieldType.getLocalizedString(4)) == 0) {
            attribute.setType(4, false, vwMapNode);
        } else if (newType.compareTo(VWFieldType.getLocalizedString(4) + ARRAY) == 0) {
            attribute.setType(4, true, vwMapNode);
        } else if (newType.compareTo(VWFieldType.getLocalizedString(8)) == 0) {
            attribute.setType(8, false, vwMapNode);
        } else if (newType.compareTo(VWFieldType.getLocalizedString(8) + ARRAY) == 0) {
            attribute.setType(8, true, vwMapNode);
        } else if (newType.compareTo(VWFieldType.getLocalizedString(1)) == 0) {
            attribute.setType(1, false, vwMapNode);
        } else if (newType.compareTo(VWFieldType.getLocalizedString(1) + ARRAY) == 0) {
            attribute.setType(1, true, vwMapNode);
        } else if (newType.compareTo(VWFieldType.getLocalizedString(2)) == 0) {
            attribute.setType(2, false, vwMapNode);
        } else if (newType.compareTo(VWFieldType.getLocalizedString(2) + ARRAY) == 0) {
            attribute.setType(2, true, vwMapNode);
        }
    }

    private void onUpdateValue(Object value, int nRowIndex) {
        block6: {
            try {
                if (value != null) {
                    VWStepAttribute stepAttribute = this.getItemAt(nRowIndex);
                    if (stepAttribute != null) {
                        stepAttribute.setValue(value, this.m_mapNode);
                        this.m_authPropertyData.setDirty();
                        this.fireTableCellUpdated(nRowIndex, 2);
                        if (VWStringUtils.compare(stepAttribute.getName(), "UI_IconName") == 0) {
                            this.m_changedItems = new Vector();
                            this.m_changedItems.addElement(this.m_mapNode);
                            this.notifyPropertyChange();
                        }
                    } else {
                        this.m_tempStepAttribute.setValue(value, null);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block6;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }
}

